local cursor_move_sfx, choice_made_sfx
local Wheel = setmetatable({}, sick_wheel_mt)

local Choices = {
	{
		text=THEME:GetString("Title", "NewGame"),
		screen="Intro"
	},
	{
		text=THEME:GetString("Title", "Options"),
		screen="ScreenOptionsService"
	},
	{
		text=THEME:GetString("Title", "Quit"),
		screen="ScreenExit"
	},
}


-- the metatable for a choice in the wheel
local wheel_item_mt = {
	__index = {
		create_actors = function(self, name)
			self.name=name

			local af = Def.ActorFrame{
				Name=self.name,
				InitCommand=function(subself)
					self.container = subself
				end,
				OnCommand=function(subself)
					subself:y( self.index * 16 )
				end
			}

			af[#af+1] = Def.BitmapText{
				Font="Common normal",
				InitCommand=function(subself)
					self.bmt = subself
					subself:zoom(0.75)
					subself:diffuse(Color.Black)
				end,
				OnCommand=function(subself)
					subself:sleep(0.15 * self.index):linear(0.2):diffusealpha(1)
				end,
				OffCommand=function(subself)
					subself:sleep(0.15 * self.index):linear(0.2):diffusealpha(0)
				end
			}

			return af
		end,

		transform = function(self, item_index, num_items, has_focus)
			self.container:finishtweening()
			self.container:linear(0.2)

			if has_focus then
				self.container:diffusealpha(1)
			else
				self.container:diffusealpha(0.33)
			end

			self.bmt:settext( self.text )

		end,

		set = function(self, choice)
			if not choice then return end

			self.index = FindInTable(choice, Choices)
			self.text = choice.text
			self.screen = choice.screen
		end
	}
}


---------------------------------------------------------------------
-- Initialize generalized Event Handling function(s)
---------------------------------------------------------------------

local InputHandler = function(event)

	----------------------------------------------------------------------------

	-- if any of these, don't attempt to handle input
	if not event.PlayerNumber or not event.button then
		return false
	end

	if event.type == "InputEventType_FirstPress" then

		if event.GameButton == "MenuRight" or event.GameButton == "MenuDown" then
			Wheel:scroll_by_amount(1)
			cursor_move_sfx:play()

		elseif event.GameButton == "MenuLeft" or event.GameButton == "MenuUp" then
			Wheel:scroll_by_amount(-1)
			cursor_move_sfx:play()

		elseif event.GameButton == "Start" then
			local topscreen = SCREENMAN:GetTopScreen()
			local choice = Wheel:get_actor_item_at_focus_pos()
			choice_made_sfx:play()
			topscreen:SetNextScreenName(choice.screen)
			topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
		end
	end

	return false
end

---------------------------------------------------------------------
-- Primary ActorFrame and children
---------------------------------------------------------------------
local t = Def.ActorFrame{
	InitCommand=function(self)
		self:xy(0,0)

		-- Initiliaze the values of the SRT table for a new game.
		InitializeSRT()

		-- set_info_set() takes two arguments:
		--		a table of meaningful data to divvy up to wheel items
		--		the index of which item we want to initially give focus to
		Wheel:set_info_set(Choices, 1)

		-- queue the next command so that we can actually GetTopScreen()
		self:queuecommand("Capture")
	end,
	CaptureCommand=function(self)

		-- attach our InputHandler to the TopScreen
		SCREENMAN:GetTopScreen():AddInputCallback( InputHandler )
	end,
	TransitionScreenCommand=function(self)
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end,


	-- scrolling texture
	LoadActor(THEME:GetPathB("", "_ScrollingBackground.lua")),

	-- semitransparent purple
	Def.Quad{
		InitCommand=function(self)
			self:zoomto(_screen.w, _screen.h*3)
				:xy(_screen.cx, _screen.cy+200):diffusealpha(0.1)
				:diffusetopedge(color("#7452b5"))
		end
	},

	Def.ActorFrame{
		InitCommand=function(self) self:zoom(0.175):Center() end,
		OnCommand=function(self)
			self:bob():effectmagnitude(0,5,0):effectperiod(4)
		end,

		-- UPSRT
		LoadActor("line1.png")..{
			InitCommand=function(self)
				self:y(-400)
			end,
		},

		-- University Park
		LoadActor("line2.png")..{
			InitCommand=function(self)
				self:y(-60)
					:diffusealpha(0)
			end,
			BeginCommand=function(self)
				self:sleep(1):linear(1):diffusealpha(1)
			end
		},

		-- SteveReen Tournament
		LoadActor("line3.png")..{
			InitCommand=function(self)
				self:y(100)
					:diffusealpha(0)
			end,
			BeginCommand=function(self)
				self:sleep(2):linear(1):diffusealpha(1)
			end
		},
	},

	-- crop away on In
	-- fade out
	Def.Quad{
		OnCommand=function(self)
			self:diffuse(0,0,0,1):FullScreen():queuecommand("Crop")
		end,
		CropCommand=function(self)
			self:croptop(0)
				:linear(0.5):croptop(1)
		end,
		OffCommand=function(self)
			self:diffusealpha(0):croptop(0)
				:sleep(0.4):accelerate(0.5):diffuse(0,0,0,1)
		end
	},
}

t[#t+1] = Wheel:create_actors( "Wheel", 3, wheel_item_mt, _screen.cx , _screen.cy+55)

---------------------------------------------------------------------

t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "value.ogg"),
	InitCommand=function(self) cursor_move_sfx = self end
}

t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "start.ogg"),
	InitCommand=function(self) choice_made_sfx = self end
}

return t